/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.simulation.twisty.model;

import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.simulation.twisty.NotExistentMoveException;
import dev.aisandbox.server.simulation.twisty.model.Cell;
import dev.aisandbox.server.simulation.twisty.model.ColourEnum;
import dev.aisandbox.server.simulation.twisty.model.CompiledMove;
import dev.aisandbox.server.simulation.twisty.model.Move;
import dev.aisandbox.server.simulation.twisty.model.MoveResult;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwistyPuzzle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwistyPuzzle.class);
    public static final int HEIGHT = 880;
    public static final int WIDTH = 1173;
    private final Map<Character, Color> colorMap = Arrays.stream(ColourEnum.values()).collect(Collectors.toMap(ColourEnum::getCharacter, ColourEnum::getAwtColour));
    private final List<Cell> cells = new ArrayList<Cell>();
    private final Map<String, CompiledMove> compiledMoves = new HashMap<String, CompiledMove>();
    List<Integer> faceSizes = new ArrayList<Integer>();
    private String baseState;
    private String puzzleName;
    private String currentState;

    public void addMove(Move move) {
        if (this.compiledMoves.containsKey(move.getName())) {
            throw new IllegalArgumentException("Move already exists: " + move.getName());
        }
        this.compiledMoves.put(move.getName(), move.compileMove(this));
    }

    public void takeSnapshot() {
        StringBuilder sb = new StringBuilder();
        for (Cell cell : this.cells) {
            sb.append(cell.getColour().getCharacter());
        }
        this.baseState = sb.toString();
        this.currentState = sb.toString();
    }

    public void resetPuzzle() {
        this.currentState = this.baseState;
    }

    public void resetPuzzle(String state) {
        this.currentState = state;
    }

    public Map<Character, Color> getColourMap() {
        return this.colorMap;
    }

    public String getState() {
        return this.currentState;
    }

    public List<String> getMoveList() {
        return List.copyOf(this.getCompiledMoves().keySet());
    }

    public MoveResult applyMove(String name) throws NotExistentMoveException {
        CompiledMove move = this.getCompiledMoves().get(name);
        if (move == null) {
            throw new NotExistentMoveException(name + " doesn't exist");
        }
        this.currentState = move.applyMove(this.currentState);
        return new MoveResult(move.getCost(), move.getImage());
    }

    public boolean isSolved() {
        int cursor = 0;
        for (int faceSize : this.faceSizes) {
            char c = '\u0000';
            for (int count = 0; count < faceSize; ++count) {
                if ('\u0000' == c) {
                    c = this.currentState.charAt(cursor);
                } else if (c != this.currentState.charAt(cursor)) {
                    return false;
                }
                ++cursor;
            }
        }
        log.info("Puzzle solved {}", (Object)this.currentState);
        return true;
    }

    public void drawPuzzle(Graphics2D g, int originX, int originY, Theme theme) {
        g.setColor(theme.getBaize());
        g.fillRect(originX, originY, 1173, 880);
        for (int i = 0; i < this.getCells().size(); ++i) {
            Cell cell = this.getCells().get(i);
            char state = this.currentState.charAt(i);
            Polygon polygon = cell.getPolygon();
            polygon.translate(originX, originY);
            g.setColor(this.colorMap.get(Character.valueOf(state)));
            g.fillPolygon(polygon);
            g.setColor(Color.LIGHT_GRAY);
            g.drawPolygon(polygon);
        }
    }

    public void centerPuzzle() {
        log.info("Centering puzzle");
        Rectangle2D bounds = this.cells.getFirst().getPolygon().getBounds2D();
        for (Cell cell : this.cells) {
            bounds = bounds.createUnion(cell.getPolygon().getBounds2D());
        }
        log.info("Initial bounds {}", (Object)bounds);
        int dx = (int)(-bounds.getMinX() + (1173.0 - bounds.getWidth()) / 2.0);
        int dy = (int)(-bounds.getMinY() + (880.0 - bounds.getHeight()) / 2.0);
        log.info("Moving cells {},{}", (Object)dx, (Object)dy);
        for (Cell cell : this.cells) {
            cell.setLocationX(dx + cell.getLocationX());
            cell.setLocationY(dy + cell.getLocationY());
        }
    }

    @Generated
    public TwistyPuzzle() {
    }

    @Generated
    public List<Cell> getCells() {
        return this.cells;
    }

    @Generated
    public Map<String, CompiledMove> getCompiledMoves() {
        return this.compiledMoves;
    }

    @Generated
    public List<Integer> getFaceSizes() {
        return this.faceSizes;
    }

    @Generated
    public String getBaseState() {
        return this.baseState;
    }

    @Generated
    public void setBaseState(String baseState) {
        this.baseState = baseState;
    }

    @Generated
    public String getPuzzleName() {
        return this.puzzleName;
    }

    @Generated
    public void setPuzzleName(String puzzleName) {
        this.puzzleName = puzzleName;
    }

    @Generated
    public String getCurrentState() {
        return this.currentState;
    }
}

