/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.simulation.maze;

import dev.aisandbox.server.simulation.maze.Cell;
import dev.aisandbox.server.simulation.maze.Direction;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Maze {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Maze.class);
    private final String boardID = UUID.randomUUID().toString();
    private final int width;
    private final int height;
    private final Cell[][] cellArray;
    private final List<Cell> cellList = new ArrayList<Cell>();
    private final int zoomLevel;
    private Cell startCell = null;
    private Cell endCell = null;

    public Maze(int width, int height, int zoomLevel) {
        log.info("Generated maze {} with dimensions {}x{}", new Object[]{this.boardID, width, height});
        this.width = width;
        this.height = height;
        this.zoomLevel = zoomLevel;
        this.cellArray = new Cell[width][height];
        this.prepareGrid();
        this.joinGrid();
    }

    private void prepareGrid() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                Cell c;
                this.cellArray[x][y] = c = new Cell(x, y);
                this.cellList.add(c);
            }
        }
    }

    private void joinGrid() {
        for (Cell c : this.cellList) {
            if (c.getPositionY() > 0) {
                c.linkBi(Direction.NORTH, this.cellArray[c.getPositionX()][c.getPositionY() - 1]);
            }
            if (c.getPositionX() <= 0) continue;
            c.linkBi(Direction.WEST, this.cellArray[c.getPositionX() - 1][c.getPositionY()]);
        }
    }

    @Generated
    public String getBoardID() {
        return this.boardID;
    }

    @Generated
    public int getWidth() {
        return this.width;
    }

    @Generated
    public int getHeight() {
        return this.height;
    }

    @Generated
    public Cell[][] getCellArray() {
        return this.cellArray;
    }

    @Generated
    public List<Cell> getCellList() {
        return this.cellList;
    }

    @Generated
    public int getZoomLevel() {
        return this.zoomLevel;
    }

    @Generated
    public Cell getStartCell() {
        return this.startCell;
    }

    @Generated
    public void setStartCell(Cell startCell) {
        this.startCell = startCell;
    }

    @Generated
    public Cell getEndCell() {
        return this.endCell;
    }

    @Generated
    public void setEndCell(Cell endCell) {
        this.endCell = endCell;
    }
}

