/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine.widget;

import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.engine.widget.GraphicsUtils;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import lombok.Generated;

public class TextWidget {
    private final int width;
    private final int height;
    private final int lineHeight;
    private final Theme theme;
    private final int PADDING = 20;
    private final BufferedImage image;
    private final Graphics2D graphics;
    private final BufferedImage blankLine;
    private final FontMetrics fontMetrics;
    private final int DESCENDER;

    private TextWidget(int width, int height, Font font, Theme theme) {
        this.width = width;
        this.height = height;
        this.lineHeight = font.getSize() + 2;
        this.theme = theme;
        this.image = GraphicsUtils.createBlankImage(width, height, theme.getWidgetBackground());
        this.graphics = this.image.createGraphics();
        this.blankLine = GraphicsUtils.createBlankImage(width - 20, this.lineHeight, theme.getWidgetBackground());
        this.graphics.setColor(theme.getText());
        this.graphics.setFont(font);
        GraphicsUtils.setupRenderingHints(this.graphics);
        this.fontMetrics = this.graphics.getFontMetrics();
        this.DESCENDER = this.fontMetrics.getDescent();
    }

    public static TextWidgetBuilder builder() {
        return new TextWidgetBuilder();
    }

    public void addText(String text) {
        if (this.fontMetrics.stringWidth(text) <= this.width - 40) {
            this.addTextLine(text);
        } else {
            StringBuilder line = new StringBuilder();
            for (String word : text.split(" ")) {
                if (line.isEmpty()) {
                    line.append(word);
                    line.append(" ");
                }
                if (this.fontMetrics.stringWidth(String.valueOf(line) + word) <= this.width - 40) {
                    line.append(word);
                    line.append(" ");
                    continue;
                }
                this.addTextLine(line.toString());
                line.setLength(0);
                line.append(word);
            }
            if (!line.isEmpty()) {
                this.addTextLine(line.toString());
            }
        }
    }

    private void addTextLine(String text) {
        BufferedImage scrollImage = this.image.getSubimage(20, 20 + this.lineHeight, this.width - 20, this.height - 40 - this.lineHeight);
        this.graphics.drawImage((Image)scrollImage, 20, 20, null);
        this.graphics.drawImage((Image)this.blankLine, 20, this.height - 20 - this.lineHeight, null);
        this.graphics.drawString(text, 20, this.height - 20 - this.DESCENDER);
    }

    public void reset() {
        this.graphics.setColor(this.theme.getWidgetBackground());
        this.graphics.fillRect(0, 0, this.width, this.height);
        this.graphics.setColor(this.theme.getText());
    }

    @Generated
    int getWidth() {
        return this.width;
    }

    @Generated
    Theme getTheme() {
        return this.theme;
    }

    @Generated
    public BufferedImage getImage() {
        return this.image;
    }

    public static class TextWidgetBuilder {
        private int width = 200;
        private int height = 200;
        private Font font = new Font("SansSerif", 0, 16);
        private Theme theme = Theme.LIGHT;

        public TextWidget build() {
            return new TextWidget(this.width, this.height, this.font, this.theme);
        }

        @Generated
        public TextWidgetBuilder width(int width) {
            this.width = width;
            return this;
        }

        @Generated
        public TextWidgetBuilder height(int height) {
            this.height = height;
            return this;
        }

        @Generated
        public TextWidgetBuilder font(Font font) {
            this.font = font;
            return this;
        }

        @Generated
        public TextWidgetBuilder theme(Theme theme) {
            this.theme = theme;
            return this;
        }
    }
}

