/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine.widget;

import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.engine.output.OutputConstants;
import dev.aisandbox.server.engine.widget.GraphicsUtils;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import lombok.Generated;
import org.apache.commons.statistics.descriptive.DoubleStatistics;
import org.apache.commons.statistics.descriptive.Statistic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingStatisticsWidget {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RollingStatisticsWidget.class);
    private static final String DOUBLE_FORMAT = "%.2f";
    private final int width;
    private final int height;
    private final int padding;
    private final int windowSize;
    private final Theme theme;
    private final boolean opaque;
    private final List<Double> values = new ArrayList<Double>();
    private final String STD = "\u03c3";
    private final String SQR = "\u00b2";
    private BufferedImage cachedImage = null;

    public RollingStatisticsWidget(int width, int height, int padding, int windowSize, Theme theme, boolean opaque) {
        this.width = width;
        this.height = height;
        this.padding = padding;
        this.windowSize = windowSize;
        this.theme = theme;
        this.opaque = opaque;
    }

    public static RollingStatisticsWidgetBuilder builder() {
        return new RollingStatisticsWidgetBuilder();
    }

    public void addScore(double score) {
        this.values.add(score);
        while (this.values.size() > this.windowSize) {
            this.values.removeFirst();
        }
        this.cachedImage = null;
    }

    public BufferedImage getImage() {
        if (this.cachedImage == null) {
            this.cachedImage = this.renderStatistics();
        }
        return this.cachedImage;
    }

    public BufferedImage renderStatistics() {
        BufferedImage image;
        BufferedImage bufferedImage = image = this.opaque ? GraphicsUtils.createBlankImage(this.width, this.height, this.theme.getWidgetBackground()) : GraphicsUtils.createClearImage(this.width, this.height);
        if (!this.values.isEmpty()) {
            Graphics2D g = image.createGraphics();
            GraphicsUtils.setupRenderingHints(g);
            DoubleStatistics stats = DoubleStatistics.of(EnumSet.of(Statistic.MIN, Statistic.MAX, Statistic.MEAN, Statistic.VARIANCE, Statistic.STANDARD_DEVIATION), (double[])this.values.stream().mapToDouble(d -> d).toArray());
            GraphicsUtils.drawCenteredText(g, 0, this.padding, this.width, 32, "Statistics", OutputConstants.STATISTICS_FONT, this.theme.getText());
            int cursorY = 32 + (this.height - 160) / 2;
            GraphicsUtils.drawCenteredText(g, 0, cursorY, this.width, 32, "Minimum: " + String.format(DOUBLE_FORMAT, stats.getAsDouble(Statistic.MIN)), OutputConstants.STATISTICS_FONT, this.theme.getText());
            GraphicsUtils.drawCenteredText(g, 0, cursorY += 32, this.width, 32, "Maximum: " + String.format(DOUBLE_FORMAT, stats.getAsDouble(Statistic.MAX)), OutputConstants.STATISTICS_FONT, this.theme.getText());
            GraphicsUtils.drawCenteredText(g, 0, cursorY += 32, this.width, 32, "Mean: " + String.format(DOUBLE_FORMAT, stats.getAsDouble(Statistic.MEAN)), OutputConstants.STATISTICS_FONT, this.theme.getText());
            GraphicsUtils.drawCenteredText(g, 0, cursorY += 32, this.width, 32, "\u03c3: " + String.format(DOUBLE_FORMAT, stats.getAsDouble(Statistic.STANDARD_DEVIATION)), OutputConstants.STATISTICS_FONT, this.theme.getText());
            GraphicsUtils.drawCenteredText(g, 0, cursorY += 32, this.width, 32, "\u03c3\u00b2: " + String.format(DOUBLE_FORMAT, stats.getAsDouble(Statistic.VARIANCE)), OutputConstants.STATISTICS_FONT, this.theme.getText());
        }
        return image;
    }

    public static class RollingStatisticsWidgetBuilder {
        private int width = 200;
        private int height = 200;
        private int padding = 40;
        private int windowSize = 200;
        private boolean opaque = true;
        private Theme theme = Theme.LIGHT;

        public RollingStatisticsWidget build() {
            return new RollingStatisticsWidget(this.width, this.height, this.padding, this.windowSize, this.theme, this.opaque);
        }

        @Generated
        public RollingStatisticsWidgetBuilder width(int width) {
            this.width = width;
            return this;
        }

        @Generated
        public RollingStatisticsWidgetBuilder height(int height) {
            this.height = height;
            return this;
        }

        @Generated
        public RollingStatisticsWidgetBuilder padding(int padding) {
            this.padding = padding;
            return this;
        }

        @Generated
        public RollingStatisticsWidgetBuilder windowSize(int windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        @Generated
        public RollingStatisticsWidgetBuilder opaque(boolean opaque) {
            this.opaque = opaque;
            return this;
        }

        @Generated
        public RollingStatisticsWidgetBuilder theme(Theme theme) {
            this.theme = theme;
            return this;
        }
    }
}

