/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine.maths.bins;

import dev.aisandbox.server.engine.maths.BinContents;
import dev.aisandbox.server.engine.maths.bins.BinningEngine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

public class IntegerBinner
implements BinningEngine {
    private final int minValue;
    private final int maxValue;

    @Override
    public List<BinContents> binValues(List<Double> values) {
        HashMap binmap = new HashMap();
        values.forEach(value -> {
            int vInt = value.intValue();
            binmap.computeIfPresent(vInt, (k, v) -> v + 1);
            binmap.putIfAbsent(vInt, 1);
        });
        ArrayList<BinContents> bins = new ArrayList<BinContents>();
        for (int n = this.minValue; n <= this.maxValue; ++n) {
            int count = binmap.getOrDefault(n, 1);
            bins.add(new BinContents((double)n - 0.5, (double)n + 0.5, count, (double)count / (double)values.size()));
        }
        return bins;
    }

    @Generated
    public IntegerBinner(int minValue, int maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }
}

