/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.simulation.mine;

import dev.aisandbox.server.simulation.mine.Cell;
import dev.aisandbox.server.simulation.mine.CellLocation;
import dev.aisandbox.server.simulation.mine.GameState;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Board {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Board.class);
    private final int width;
    private final int height;
    private final Cell[][] grid;
    private final String boardID = UUID.randomUUID().toString();
    private GameState state = GameState.INIT;
    private int unfoundMines = 0;

    public Board(int width, int height) {
        this.width = width;
        this.height = height;
        this.grid = new Cell[width][height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                this.grid[x][y] = new Cell();
            }
        }
    }

    public void placeMines(Random rand, int count) {
        count = Math.min(count, this.width * this.height);
        while (count > 0) {
            Cell c = this.grid[rand.nextInt(this.width)][rand.nextInt(this.height)];
            if (c.isMine()) continue;
            c.setMine(true);
            --count;
            ++this.unfoundMines;
        }
    }

    protected Cell getCell(int x, int y) {
        return this.grid[x][y];
    }

    public String[] getBoardToString() {
        String[] result = new String[this.grid[0].length];
        for (int y = 0; y < this.height; ++y) {
            result[y] = this.getRowToString(y);
        }
        return result;
    }

    public String getRowToString(int y) {
        StringBuilder sb = new StringBuilder();
        for (int x = 0; x < this.width; ++x) {
            sb.append(this.grid[x][y].getPlayerView());
        }
        return sb.toString();
    }

    public void countNeighbours() {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.grid[x][y].setNeighbours(this.countNeighbours(x, y));
            }
        }
        this.state = GameState.PLAYING;
    }

    private int countNeighbours(int x, int y) {
        int count = 0;
        for (int dx = -1; dx < 2; ++dx) {
            for (int dy = -1; dy < 2; ++dy) {
                if (dx == 0 && dy == 0) continue;
                count += this.getMineBounds(x + dx, y + dy);
            }
        }
        return count;
    }

    private int getMineBounds(int x, int y) {
        try {
            return this.grid[x][y].isMine() ? 1 : 0;
        }
        catch (IndexOutOfBoundsException e) {
            return 0;
        }
    }

    public boolean placeFlag(int x, int y) {
        log.info("Placing flag @ {},{}", (Object)x, (Object)y);
        Cell c = this.grid[x][y];
        boolean change = false;
        if (c.isFlagged()) {
            log.info("Flagging an already flagged cell - ignoring");
        } else if (!c.isCovered()) {
            log.info("Flagging an uncovered tile - ignoring");
        } else if (c.isMine()) {
            log.info("Correctly found a mine");
            c.setFlagged(true);
            --this.unfoundMines;
            change = true;
        } else {
            log.info("Incorrectly marked a mine");
            c.setFlagged(true);
            this.state = GameState.LOST;
            change = true;
        }
        if (this.unfoundMines == 0) {
            this.state = GameState.WON;
        }
        return change;
    }

    public boolean uncover(int x, int y) {
        Cell c = this.grid[x][y];
        boolean change = false;
        if (c.isFlagged() || !c.isCovered()) {
            log.warn("trying to uncover an used cell - ignoring");
        } else {
            c.setCovered(false);
            change = true;
            if (c.isMine()) {
                log.info("Bad move");
                this.state = GameState.LOST;
            } else if (c.getNeighbours() == 0) {
                this.floodFill(x, y);
            }
        }
        return change;
    }

    private void floodFill(int x, int y) {
        HashSet<CellLocation> visited = new HashSet<CellLocation>();
        ArrayList<CellLocation> stack = new ArrayList<CellLocation>();
        stack.add(new CellLocation(x, y));
        while (!stack.isEmpty()) {
            CellLocation currentCellLocation = (CellLocation)stack.remove(0);
            Cell currentCell = this.grid[currentCellLocation.x()][currentCellLocation.y()];
            visited.add(currentCellLocation);
            currentCell.setCovered(false);
            if (currentCell.getNeighbours() != 0) continue;
            List<CellLocation> neighbours = this.getNeighbours(currentCellLocation);
            for (CellLocation c : neighbours) {
                if (visited.contains(c) || stack.contains(c)) continue;
                stack.add(c);
            }
        }
    }

    private List<CellLocation> getNeighbours(CellLocation c) {
        ArrayList<CellLocation> result = new ArrayList<CellLocation>();
        for (int dx = -1; dx < 2; ++dx) {
            int x = c.x() + dx;
            if (x < 0 || x >= this.width) continue;
            for (int dy = -1; dy < 2; ++dy) {
                int y = c.y() + dy;
                if (y < 0 || y >= this.height) continue;
                result.add(new CellLocation(x, y));
            }
        }
        return result;
    }

    @Generated
    public int getWidth() {
        return this.width;
    }

    @Generated
    public int getHeight() {
        return this.height;
    }

    @Generated
    public String getBoardID() {
        return this.boardID;
    }

    @Generated
    public GameState getState() {
        return this.state;
    }

    @Generated
    public int getUnfoundMines() {
        return this.unfoundMines;
    }
}

