/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.simulation.maze;

import dev.aisandbox.server.engine.Agent;
import dev.aisandbox.server.engine.Simulation;
import dev.aisandbox.server.engine.SimulationBuilder;
import dev.aisandbox.server.engine.SimulationParameter;
import dev.aisandbox.server.engine.Theme;
import dev.aisandbox.server.simulation.maze.MazeRunner;
import dev.aisandbox.server.simulation.maze.MazeSize;
import dev.aisandbox.server.simulation.maze.MazeType;
import java.util.List;
import java.util.Random;
import lombok.Generated;

public final class MazeBuilder
implements SimulationBuilder {
    private MazeSize mazeSize = MazeSize.MEDIUM;
    private MazeType mazeType = MazeType.BINARYTREE;

    @Override
    public String getSimulationName() {
        return "Maze";
    }

    @Override
    public String getDescription() {
        return "Navigate the maze and find the exit, then optimise the path to find the shortest route. The AI agent will be placed in a Maze and tasked with finding its way to the exit. Once there it will be rewarded and sent to a random position. At each turn the AI agent is given information about the maze (dimensions, directions etc), the result of the last move (any reward) and asked for the next move. This repeats until the episode finished.";
    }

    @Override
    public List<SimulationParameter> getParameters() {
        return List.of(new SimulationParameter("mazeSize", "The size of the maze", MazeSize.class), new SimulationParameter("mazeType", "The style of the maze", MazeType.class));
    }

    @Override
    public int getMinAgentCount() {
        return 1;
    }

    @Override
    public int getMaxAgentCount() {
        return 1;
    }

    @Override
    public String[] getAgentNames(int agentCount) {
        return new String[]{"Agent 1"};
    }

    @Override
    public Simulation build(List<Agent> agents, Theme theme, Random random) {
        return new MazeRunner(agents.getFirst(), this.mazeSize, this.mazeType, theme, random);
    }

    @Generated
    public MazeSize getMazeSize() {
        return this.mazeSize;
    }

    @Generated
    public void setMazeSize(MazeSize mazeSize) {
        this.mazeSize = mazeSize;
    }

    @Generated
    public MazeType getMazeType() {
        return this.mazeType;
    }

    @Generated
    public void setMazeType(MazeType mazeType) {
        this.mazeType = mazeType;
    }
}

