/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine.output;

import dev.aisandbox.server.engine.Simulation;
import dev.aisandbox.server.engine.output.OutputRenderer;
import dev.aisandbox.server.fx.RuntimeController;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FXRenderer
implements OutputRenderer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FXRenderer.class);
    private final RuntimeController runtime;
    int skipframes = 0;
    private Simulation simulation;
    private long imageCounter = 0L;

    @Override
    public String getName() {
        return "JavaFX Renderer";
    }

    @Override
    public void setup(Simulation simulation) {
        this.simulation = simulation;
    }

    @Override
    public void setSkipFrames(int framesToSkip) {
        this.skipframes = framesToSkip;
    }

    @Override
    public void display() {
        if (this.skipframes == 0 || this.imageCounter % (long)this.skipframes == 0L) {
            BufferedImage image = new BufferedImage(1920, 1080, 1);
            Graphics2D g2d = image.createGraphics();
            this.simulation.visualise(g2d);
            this.runtime.updateImage(image);
        }
        ++this.imageCounter;
    }

    @Override
    public void write(String text) {
        this.runtime.updateOutput(text);
    }

    @Generated
    public FXRenderer(RuntimeController runtime) {
        this.runtime = runtime;
    }
}

