/*
 * Decompiled with CFR 0.152.
 */
package dev.aisandbox.server.engine.maths.bins;

import dev.aisandbox.server.engine.maths.BinContents;
import dev.aisandbox.server.engine.maths.StatisticsUtils;
import dev.aisandbox.server.engine.maths.bins.BinningEngine;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class EqualWidthBinner
implements BinningEngine {
    @Override
    public List<BinContents> binValues(List<Double> values) {
        Pair<Double, Double> minMax = StatisticsUtils.getMinMax(values);
        double minimumValue = (Double)minMax.getLeft();
        double maximumValue = (Double)minMax.getRight();
        double range = maximumValue - minimumValue;
        int binCount = (int)Math.ceil(Math.sqrt(values.size()));
        double width = range / (double)binCount;
        ArrayList<Double> binStarts = new ArrayList<Double>();
        ArrayList<Double> binEnds = new ArrayList<Double>();
        binStarts.add(minimumValue);
        for (int i = 1; i < binCount; ++i) {
            double split = minimumValue + width * (double)i;
            binEnds.add(split);
            binStarts.add(split);
        }
        binEnds.add(maximumValue);
        return StatisticsUtils.getBinnedValues(values, binStarts, binEnds);
    }
}

