/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.descriptive;

import java.math.BigInteger;
import org.apache.commons.statistics.descriptive.Int128;
import org.apache.commons.statistics.descriptive.IntStatistic;
import org.apache.commons.statistics.descriptive.StatisticAccumulator;

public final class IntSum
implements IntStatistic,
StatisticAccumulator<IntSum> {
    private final Int128 sum;

    private IntSum() {
        this(Int128.create());
    }

    private IntSum(Int128 sum) {
        this.sum = sum;
    }

    public static IntSum create() {
        return new IntSum();
    }

    public static IntSum of(int ... values) {
        long s = 0L;
        for (int x : values) {
            s += (long)x;
        }
        return new IntSum(Int128.of(s));
    }

    Int128 getSum() {
        return this.sum;
    }

    @Override
    public void accept(int value) {
        this.sum.add(value);
    }

    @Override
    public int getAsInt() {
        return this.sum.toIntExact();
    }

    @Override
    public long getAsLong() {
        return this.sum.toLongExact();
    }

    @Override
    public double getAsDouble() {
        return this.sum.toDouble();
    }

    @Override
    public BigInteger getAsBigInteger() {
        return this.sum.toBigInteger();
    }

    @Override
    public IntSum combine(IntSum other) {
        this.sum.add(other.sum);
        return this;
    }
}

